{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitAtractor;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, MMSystem, StdCtrls;

type
  TFormAtractor = class(TForm)
    Panel: TPanel;
    SpeedButtonEngegarParar: TSpeedButton;
    SpeedButtonCaixaEines: TSpeedButton;
    SpeedButtonCopiarALaCarpeta: TSpeedButton;
    CheckBoxNoIniciar: TCheckBox;
    procedure SpeedButtonEngegarPararClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure SpeedButtonCaixaEinesClick(Sender: TObject);
    procedure SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
  public
    { Public declarations }
    x,y,inc,a,xx:single;
  end;

var
  FormAtractor: TFormAtractor;

{************************************************}
IMPLEMENTATION
{************************************************}

Uses UnitEntradaSo, UnitCanviDeParametres, UnitTools;

{$R *.DFM}

procedure TFormAtractor.FormCreate(Sender: TObject);
begin
  Randomize;
end;

procedure TFormAtractor.FormClose(Sender: TObject;var Action: TCloseAction);
begin
  if not (SpeedButtonEngegarParar.Caption='E') then begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
  end;
end;

procedure TFormAtractor.SpeedButtonEngegarPararClick(Sender: TObject);
begin
  if SpeedButtonEngegarParar.Caption='E' then begin
    SpeedButtonEngegarParar.Caption:='P';
    RePaint;
    IniciarDadesUnitEntradaSo(512);
    x:=0;
    y:=0;
    inc:=0.01;
    A:=1.5732;
    EngegarProcesEntradaSo(Handle);
  end else begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
  end;
end;

procedure TFormAtractor.WMWIMDATA(var Msg: TMessage);
var
  i,n,Max:integer;
  R:TRect;
  x1,y1:integer;
begin
  Max:=0;
  For i:=1 to BytesBuffer do if so[NumeroBufer,i]-127>Max then Max:=so[NumeroBufer,i]-127;
  if Max>ValorMinim then begin
    R:=GetClientRect;
    x1:=(R.Right -R.Left) div 2;
    y1:=(R.Bottom -R.Top) div 2;
    for n:=1 to 8 do begin
      for i:=1 to 100 do begin
        try
          xx:=x*cos(A)-(y-x*x)*sin(A);
          y:=x*sin(A)+(y-x*x)*cos(A);
          x:=xx;
          {
          if x>1 then begin
            PararEntradaSo;
            FinalitzarEntradaSo;
            SpeedButtonEngegarParar.Caption:='E';
            SpeedButtonEngegarParar.Down:=false;
          end;
          }
        except
          PararEntradaSo;
          FinalitzarEntradaSo;
          SpeedButtonEngegarParar.Caption:='E';
          SpeedButtonEngegarParar.Down:=false;
        end;
        if (x<=1) and (y<=1) then begin
          //PSET (300 * x + 320, 300 * y + 175), (i% MOD 4) + 1
          if i mod 4 = 0 then begin
            Canvas.Pen.Color:=clBlue;
          end else if i mod 4 = 1 then begin
            Canvas.Pen.Color:=clYellow;
          end else if i mod 4 = 2 then begin
            Canvas.Pen.Color:=clRed;
          end else if i mod 4 = 3 then begin
            Canvas.Pen.Color:=clGreen;
          end;
          Canvas.MoveTo(Round(400*x+X1-1),Round(400*y+Y1));
          Canvas.LineTo(Round(400*x+X1),Round(400*y+Y1));
        end;
      end;
      x:=x+inc;
    end;
  end else begin
    if not CheckBoxNoIniciar.Checked then begin
      Repaint;
      x:=0;
      y:=0;
      inc:=0.01;
      A:=1.5732;
    end;
  end;
  EntradaSo;
end;

procedure TFormAtractor.SpeedButtonCaixaEinesClick(Sender: TObject);
begin
  FormCanviDeParametres.ShowModal;
end;

procedure TFormAtractor.SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
var
  Rect:TRect;
begin
  Rect.Left:=0;
  Rect.Top:=Panel.Height;
  Rect.Right:=ClientRect.Right;
  Rect.Bottom:=ClientRect.Bottom;
  CopiarPartDeLaFinestraALaCarpeta(Handle,Rect);
end;

procedure TFormAtractor.FormMouseDown(Sender: TObject;Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbleft then begin
  end else begin
    if not (SpeedButtonEngegarParar.Caption='E') then begin
      PararEntradaSo;
      FinalitzarEntradaSo;
      SpeedButtonEngegarParar.Caption:='E';
      SpeedButtonEngegarParar.Down:=false;
    end;
  end;
end;

end.
